#ifndef EEPROM_H
#define EEPROM_H

#define EepErase 0x08
#define EepWrite 0x02
#define EepRead  0x01

#define EepEraseFlag 0x80
#define EepWriteFlag 0x20
#define EepReadFlag 0x10

// <<< Use Configuration Wizard in Context Menu >>>

// <q> EEPROM  Enable/Disable
	#define EEPROM_MODE	0


// <<< end of configuration section >>>

	#if (EEPROM_MODE==1)
		extern void EEP_Power_Init_read_data(void);
		extern uint8 EEP_Read (uint8);
		extern void EEP_Erase (void);
		extern void EEP_Write (uint8,uint8);
		extern void EEP_Storage(void);
			
		typedef struct{	
			uint8 	eprom_data;
			uint8 	EEP_SpeedNum;
			uint8 	EEP_once_doing;
		}USER_Eeprom;

		extern	USER_Eeprom		idata	u_Eeprom;
	#endif	
#endif